const upper = (x) => x.toUpperCase();
const lower = (x) => x.toLowerCase();
const capitalize = (x) => x.length ? x[0].toUpperCase() + x.substring(1) : x;
const kebab = (x, delim = "-") => lower(
  x.replace(
    // TC39
    // /(?<=[a-z0-9\u00e0-\u00fd])(?=[A-Z\u00c0-\u00dd])/g,
    // (_, i) => (i ? delim : "")
    /([a-z0-9\u00e0-\u00fd])([A-Z\u00c0-\u00dd])/g,
    (_, a, b) => a + delim + b
  )
);
const snake = (x) => kebab(x, "_");
const upperSnake = (x) => snake(x).toUpperCase();
const camel = (x, delim = "-") => lower(x).replace(new RegExp(`\\${delim}+(\\w)`, "g"), (_, c) => upper(c));
export {
  camel,
  capitalize,
  kebab,
  lower,
  snake,
  upper,
  upperSnake
};
