/**
 * Takes a string, linear index position and optional line split delimiter (or
 * regexp, default: "\n"). Computes and returns position of index as cursor
 * coords tuple: `[line, column]`
 *
 * @remarks
 * By default the returned coords are 1-based, but can be configured via
 * optional `offset` arg (also in `[line,column]` order).
 *
 * @example
 * ```ts tangle:../export/compute-cursor-pos.ts
 * import { computeCursorPos } from "@thi.ng/strings";
 *
 * console.log(
 *   computeCursorPos("thi.ng\numbrella", 10)
 * );
 * // [ 2, 4 ]
 *
 * // w/ custom offset
 * console.log(
 *   computeCursorPos("thi.ng\numbrella", 10, "\n", [11, 1])
 * );
 * // [ 12, 4 ]
 * ```
 *
 * @param str -
 * @param pos -
 * @param delim -
 * @param offset -
 */
export declare const computeCursorPos: (str: string, pos: number, delim?: string | RegExp, offset?: number[]) => number[];
//# sourceMappingURL=cursor.d.ts.map