const ENTITIES = {
  "&": "&amp;",
  "<": "&lt;",
  ">": "&gt;",
  "\u2264": "&le;",
  "\u2265": "&ge;",
  '"': "&quot;",
  "'": "&apos;",
  "\u2014": "&mdash;",
  "\u2013": "&ndash;",
  "\u2026": "&hellip;",
  "\u22EE": "&vellip;",
  "\u22EF": "&ctdot;",
  "\xA2": "&cent;",
  "\u20AC": "&euro;",
  "\xA3": "&pound;",
  "\xA5": "&yen;",
  "\u20B9": "&#8377;",
  \u5143: "&#20803;",
  "\xA7": "&sect;",
  "\xB6": "&para;",
  "\xA9": "&copy;",
  "\xAE": "&reg;",
  "\u2122": "&trade;",
  "\u2103": "&#8451;",
  "\u2109": "&#8457;",
  "\u212A": "&#8490;",
  // Kelvin
  "\u25C2": "&ltrif;",
  "\u25B8": "&rtrif;",
  "\u25B4": "&utrif;",
  "\u25BE": "&dtrif;",
  "\u2190": "&larr;",
  "\u2192": "&rarr;",
  "\u2191": "&uarr;",
  "\u2193": "&darr;",
  "\u21B5": "&crarr;",
  "\u21A9": "&larrhk;",
  "\u21D0": "&lArr;",
  "\u21D2": "&rArr;",
  "\u21BA": "&olarr;",
  "\u21BB": "&orarr;",
  "\xB9": "&sup1;",
  "\xB2": "&sup2;",
  "\xB3": "&sup3;",
  "\xBD": "&frac12;",
  "\u2153": "&frac13;",
  "\u2154": "&frac23;",
  "\xBC": "&frac14;",
  "\xBE": "&frac34;",
  "\u2155": "&frac15;",
  "\u2159": "&frac16;",
  "\u215B": "&frac18;",
  \u00C4: "&Auml;",
  \u00CB: "&Euml;",
  \u00CF: "&Iuml;",
  \u00D6: "&Ouml;",
  \u00DC: "&Uuml;",
  \u00E4: "&auml;",
  \u00EB: "&euml;",
  \u00EF: "&iuml;",
  \u00F6: "&ouml;",
  \u00FC: "&uuml;",
  \u00DF: "&szlig;",
  \u03B1: "&alpha;",
  \u03B2: "&beta;",
  \u03B3: "&gamma;",
  \u03B4: "&delta;",
  \u03B5: "&epsi;",
  \u03B8: "&theta;",
  \u03BB: "&lambda;",
  \u03BC: "&mu;",
  \u03C0: "&pi;",
  \u03C3: "&sigma;",
  \u03C4: "&tau;",
  \u03C6: "&phi;",
  \u03C9: "&omega;",
  \u0394: "&Delta;",
  \u03A9: "&Omega;",
  "\u221E": "&infin;",
  "\xB1": "&plusmn;",
  "\u2A2F": "&Cross;",
  "\xB0": "&deg;",
  "\u2211": "&sum;",
  "\u220F": "&prod;",
  "\u222B": "&int;",
  "\u221A": "&radic;",
  "\u2220": "&angle;",
  "\u2227": "&and;",
  "\u2228": "&or;",
  "\u2229": "&cap;",
  "\u222A": "&cup;",
  "\u2282": "&sub;",
  "\u2283": "&sup;",
  "\u2208": "&isin;",
  "\u2209": "&notin;",
  "\u2205": "&empty;",
  "\u2295": "&oplus;",
  "\u2296": "&ominus;",
  "\u2297": "&otimes;",
  "\u2316": "&target;",
  "\u2606": "&star;",
  "\u2605": "&starf;",
  "\u2713": "&check;",
  "\u2717": "&cross;",
  "\xA0": "&nbsp;"
};
const RE_ENTITIES = new RegExp(
  `[${Object.keys(ENTITIES).join("")}]`,
  "gu"
);
const ENTITIES_REV = Object.entries(ENTITIES).reduce(
  (acc, [k, v]) => (acc[v] = k, acc),
  {}
);
const RE_ENTITIES_REV = new RegExp(
  `(${Object.keys(ENTITIES_REV).join("|")})`,
  "g"
);
const RE_ENTITIES_NUM = /&#(x?)([0-9a-f]+);/gi;
const escapeEntities = (src) => src.replace(RE_ENTITIES, (x) => ENTITIES[x]);
const escapeEntitiesNum = (src) => src.replace(RE_ENTITIES, (x) => {
  const code = x.charCodeAt(0);
  return code < 128 ? ENTITIES[x] : `&#x${code.toString(16)};`;
});
const unescapeEntities = (src) => src.replace(RE_ENTITIES_REV, (x) => ENTITIES_REV[x]).replace(
  RE_ENTITIES_NUM,
  (_, hex, x) => String.fromCharCode(parseInt(x, hex ? 16 : 10))
);
export {
  ENTITIES,
  ENTITIES_REV,
  RE_ENTITIES,
  RE_ENTITIES_NUM,
  RE_ENTITIES_REV,
  escapeEntities,
  escapeEntitiesNum,
  unescapeEntities
};
