import type { IObjectOf, NumOrString } from "@thi.ng/api";
/**
 * Takes a string template with embedded `{number}` style terms and any
 * number of args. Replaces numbered terms with their respective args
 * given.
 *
 * @remarks
 * Also see {@link interpolateKeys}.
 *
 * @example
 * ```ts tangle:../export/interpolate.ts
 * import { interpolate } from "@thi.ng/strings";
 *
 * console.log(
 *   interpolate("let {0}: {2} = {1};", "a", 42, "number")
 * );
 * // "let a: number = 42;"
 * ```
 *
 * @param src -
 * @param args -
 */
export declare const interpolate: (src: string, ...args: any[]) => string;
/**
 * Similar to {@link interpolate}, but uses alphanumeric placeholders in the
 * template string and an object of values for the stated keys.
 *
 * @example
 * ```ts tangle:../export/interpolate-keys.ts
 * import { interpolateKeys } from "@thi.ng/strings";
 *
 * console.log(
 *   interpolateKeys(
 *     "let {id}: {type} = {val};",
 *     { id: "a", type: "number", val: 42 }
 *   )
 * );
 * // "let a: number = 42;"
 * ```
 *
 * @param src -
 * @param keys -
 */
export declare const interpolateKeys: (src: string, keys: IObjectOf<NumOrString>) => string;
//# sourceMappingURL=interpolate.d.ts.map