import type { Stringer } from "./api.js";
/**
 * Array of the english names of digits 0-9
 */
export declare const NAMED_DIGITS: string[];
/**
 * Higher-order formatter. Takes an array of named numbers (e.g. `["zero",
 * "one", "two"...]`) and returns a function which accepts any number and either
 * returns the corresponding name (from the given array) or otherwise the result
 * of {@link int}.
 *
 * @remarks
 * The default names used are {@link NAMED_DIGITS}.
 *
 * @example
 * ```ts tangle:../export/named-number.ts
 * import { namedNumber } from "@thi.ng/strings";
 *
 * console.log(namedNumber()(9));
 * // "nine"
 *
 * console.log(namedNumber()(10));
 * // "10"
 *
 * console.log(namedNumber(["null", "eins", "zwei"])(2));
 * // "zwei"
 * ```
 *
 * @param names
 */
export declare const namedNumber: (names?: string[]) => Stringer<number>;
//# sourceMappingURL=named-number.d.ts.map