import {
  U16 as $16,
  U24 as $24,
  U32 as $32,
  U64HL,
  U8 as $8
} from "@thi.ng/hex";
import { memoizeJ } from "@thi.ng/memoize/memoizej";
import { repeat } from "./repeat.js";
const radix = memoizeJ(
  (radix2, n, prefix = "") => {
    const buf = repeat("0", n);
    return (x) => {
      x = (x >>> 0).toString(radix2);
      return prefix + (x.length < n ? buf.substring(x.length) + x : x);
    };
  }
);
const B8 = radix(2, 8);
const B16 = radix(2, 16);
const B32 = radix(2, 32);
const U8 = $8;
const U16 = $16;
const U24 = $24;
const U32 = $32;
const U64 = U64HL;
export {
  B16,
  B32,
  B8,
  U16,
  U24,
  U32,
  U64,
  U8,
  radix
};
