import type { Stringer } from "./api.js";
/**
 * Higher order trim function (both sides) with support for user defined
 * trimmable characters (default: whitespace only).
 *
 * @example
 * ```ts tangle:../export/trim.ts
 * import { trim } from "@thi.ng/strings";
 *
 * console.log(
 *   trim()("  Hello   ")
 * );
 * // "Hello"
 *
 * console.log(
 *   trim(" -+")("-+-+- Hello -+-+-")
 * );
 * // "Hello"
 * ```
 *
 * @param chars -
 */
export declare const trim: (x: string) => Stringer<string>;
//# sourceMappingURL=trim.d.ts.map