/**
 * Returns the number of bytes required to encode the given string as UTF-8.
 *
 * @param str
 */
export declare const utf8Length: (str: string) => number;
/**
 * Non-transducer version of
 * [`utf8Decode()`](https://docs.thi.ng/umbrella/transducers-binary/functions/utf8Decode.html).
 * Decodes `num` bytes from `start` index in given byte buffer. In Firefox this
 * is much faster than using the `TextDecoder` API.
 *
 * @param buf
 * @param start
 * @param num
 */
export declare const utf8Decode: (buf: Uint8Array, start: number, num: number) => string;
/**
 * Non-transducer version of
 * [`utf8Encode()`](https://docs.thi.ng/umbrella/transducers-binary/functions/utf8Encode.html).
 *
 * @remarks
 * If `capacity` is given, initializes the byte array to that size (and assumes
 * that it is sufficient to store the entire string, e.g. by using
 * {@link utf8Length} to pre-determine the number of bytes required for a given
 * string). If `capacity` is _not_ provided, the buffer will be initialized to
 * `4 * src.length`.
 *
 * Based on:
 * - https://github.com/thi-ng/umbrella/blob/main/packages/transducers-binary/src/utf8.ts
 * - https://gist.github.com/pascaldekloe/62546103a1576803dade9269ccf76330
 *
 * @param buf
 */
export declare const utf8Encode: (src: string, capacity?: number) => Uint8Array;
/**
 * Returns character string for given UTF-8 codepoint.
 *
 * @param x
 */
export declare const fromUtf8CodePoint: (x: number) => string;
export declare const UTF8Error: {
    new (msg?: string | undefined): {
        origMessage: string;
        name: string;
        message: string;
        stack?: string;
        cause?: unknown;
    };
    captureStackTrace(targetObject: object, constructorOpt?: Function): void;
    prepareStackTrace?: ((err: Error, stackTraces: NodeJS.CallSite[]) => any) | undefined;
    stackTraceLimit: number;
};
//# sourceMappingURL=utf8.d.ts.map