import type { Stringer } from "./api.js";
/**
 * Higher order formatter for n-D vectors, with each element formatted using
 * `prec` and using optional delimiter and pre/postfixes.
 *
 * @size - vector size (optimized for size 1-4)
 * @prec - precision (see {@link float}) or existing number formatter
 * @delim - delimiter (default: `,`)
 * @pre - prefix (default: `[`)
 * @post - prefix (default: `]`)
 */
export declare const vector: (size: number, prec?: number | Stringer<number>, delim?: string, pre?: string, post?: string) => Stringer<ArrayLike<number>>;
//# sourceMappingURL=vector.d.ts.map