import type { Transducer } from "@thi.ng/transducers";
/**
 * Stateful transducer. Decodes base64 chars into bytes.
 * Supports URL safe & unsafe flavors.
 */
export declare function base64Decode(): Transducer<string, number>;
export declare function base64Decode(src: string): Uint8Array;
export interface Base64EncodeOpts {
    safe: boolean;
    buffer: number;
}
/**
 * Stateful transducer. Encodes bytes into base64 chars. Supports URL
 * safe & unsafe flavors, configurable via provided options. Uses
 * internal buffer (size also configurable, default = 1024) to store
 * intermediate results. Then repeatedly calls reducer to drain buffer
 * whenever it's been filled.
 */
export declare function base64Encode(): Transducer<number, string>;
export declare function base64Encode(opts: Partial<Base64EncodeOpts>): Transducer<number, string>;
export declare function base64Encode(src: Iterable<number>): string;
export declare function base64Encode(opts: Partial<Base64EncodeOpts>, src: Iterable<number>): string;
//# sourceMappingURL=base64.d.ts.map