import type { Transducer } from "@thi.ng/transducers";
/**
 * Transforms incoming numbers into their bitstream using specified
 * word size (default 8) and order (MSB first or LSB first). Only the
 * lowest `wordSize` bits of each value are used (max 32).
 *
 * ```ts tangle:../export/bits.ts
 * import { bits } from "@thi.ng/transducers-binary";
 * import { comp, iterator, partition } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...bits(8, [0xf0, 0xaa])]
 * );
 * // [ 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0 ]
 *
 * console.log(
 *   [...iterator(comp(bits(8), partition(4)), [0xf0, 0xaa])]
 * );
 * // [ [ 1, 1, 1, 1 ], [ 0, 0, 0, 0 ], [ 1, 0, 1, 0 ], [ 1, 0, 1, 0 ] ]
 * ```
 *
 * @param wordSize -
 * @param msbFirst -
 */
export declare function bits(wordSize?: number, msbFirst?: boolean): Transducer<number, number>;
export declare function bits(src: Iterable<number>): IterableIterator<number>;
export declare function bits(size: number, src: Iterable<number>): IterableIterator<number>;
export declare function bits(size: number, msb: boolean, src: Iterable<number>): IterableIterator<number>;
//# sourceMappingURL=bits.d.ts.map