import type { Reducer, Transducer } from "@thi.ng/transducers";
import type { BinStructItem } from "./api.js";
export declare const i8: (x: number) => BinStructItem;
export declare const i8array: (x: ArrayLike<number>) => BinStructItem;
export declare const u8: (x: number) => BinStructItem;
export declare const u8array: (x: ArrayLike<number>) => BinStructItem;
export declare const i16: (x: number, le?: boolean) => BinStructItem;
export declare const i16array: (x: ArrayLike<number>, le?: boolean) => BinStructItem;
export declare const u16: (x: number, le?: boolean) => BinStructItem;
export declare const u16array: (x: ArrayLike<number>, le?: boolean) => BinStructItem;
export declare const i24: (x: number, le?: boolean) => BinStructItem;
export declare const i24array: (x: ArrayLike<number>, le?: boolean) => BinStructItem;
export declare const u24: (x: number, le?: boolean) => BinStructItem;
export declare const u24array: (x: ArrayLike<number>, le?: boolean) => BinStructItem;
export declare const i32: (x: number, le?: boolean) => BinStructItem;
export declare const i32array: (x: ArrayLike<number>, le?: boolean) => BinStructItem;
export declare const u32: (x: number, le?: boolean) => BinStructItem;
export declare const u32array: (x: ArrayLike<number>, le?: boolean) => BinStructItem;
export declare const f32: (x: number, le?: boolean) => BinStructItem;
export declare const f32array: (x: ArrayLike<number>, le?: boolean) => BinStructItem;
export declare const f64: (x: number, le?: boolean) => BinStructItem;
export declare const f64array: (x: ArrayLike<number>, le?: boolean) => BinStructItem;
export declare const str: (x: string) => BinStructItem;
/**
 * Transducer which converts {@link BinStructItem} inputs to bytes. If
 * `src` iterable is given, yields an iterator of unsigned bytes (e.g.
 * for streaming purposes).
 *
 * @example
 * ```ts tangle:../export/as-bytes.ts
 * import {
 *   asBytes, f32, i16, str, u32,
 *   hexDumpString
 * } from "@thi.ng/transducers-binary";
 *
 * const bytes = asBytes([
 *   str("hello!"),
 *   u32(0xdecafbad),
 *   i16(-1),
 *   f32(Math.PI)
 * ]);
 *
 * console.log(hexDumpString({}, bytes));
 * // 00000000 | 68 65 6c 6c 6f 21 de ca fb ad ff ff 40 49 0f db | hello!......@I..
 * ```
 */
export declare function asBytes(): Transducer<BinStructItem, number>;
export declare function asBytes(src: Iterable<BinStructItem>): Iterable<number>;
export declare function bytes(cap?: number): Reducer<BinStructItem, Uint8Array>;
export declare function bytes(cap: number, src: Iterable<BinStructItem>): Uint8Array;
//# sourceMappingURL=bytes.d.ts.map