import type { Transducer } from "@thi.ng/transducers";
import type { HexDumpOpts } from "./api.js";
/**
 * Transforms bytes into a sequence of hexdump lines with configurable number of
 * `columns` and `address` offset. Uses
 * [`partition()`](https://docs.thi.ng/umbrella/transducers/functions/partition.html)
 * internally, so new lines are only produced once filled. If the input hasn't
 * an exact multiple of `cols` bytes, the last line will be padded with zeroes.
 *
 * @remarks
 * Also see alt implementation in
 * [thi.ng/hex](https://docs.thi.ng/umbrella/hex/functions/hexdump.html)
 *
 * @example
 * ```ts tangle:../export/hex-dump.ts
 * import { hexDump } from "@thi.ng/transducers-binary";
 *
 * const src = [
 *   65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 33, 48, 49, 50, 51, 126, 122, 121, 120
 * ];
 *
 * console.log(
 *   [...hexDump({ cols: 8, address: 0x400 }, src)].join("\n")
 * );
 * // 00000400 | 41 42 43 44 45 46 47 48 | ABCDEFGH
 * // 00000408 | 49 4a 21 30 31 32 33 7e | IJ!0123~
 * // 00000410 | 7a 79 78 00 00 00 00 00 | zyx.....
 * ```
 *
 * @param opts -
 */
export declare function hexDump(opts?: Partial<HexDumpOpts>): Transducer<number, string>;
export declare function hexDump(src: Iterable<number>): IterableIterator<string>;
export declare function hexDump(opts: Partial<HexDumpOpts>, src: Iterable<number>): IterableIterator<string>;
/**
 * Convenience wrapper for {@link hexDump}, return the hexdump as a
 * single result string.
 *
 * @param opts -
 * @param src -
 */
export declare const hexDumpString: (opts: Partial<HexDumpOpts>, src: Iterable<number>) => string;
//# sourceMappingURL=hex-dump.d.ts.map