import { juxt } from "@thi.ng/compose/juxt";
import { U32, U8 } from "@thi.ng/hex";
import { comp } from "@thi.ng/transducers/comp";
import { iterator, __iter } from "@thi.ng/transducers/iterator";
import { map } from "@thi.ng/transducers/map";
import { mapIndexed } from "@thi.ng/transducers/map-indexed";
import { padLast } from "@thi.ng/transducers/pad-last";
import { partition } from "@thi.ng/transducers/partition";
function hexDump(...args) {
  const iter = __iter(hexDump, args, iterator);
  if (iter) {
    return iter;
  }
  const { cols = 16, address = 0 } = args[0] || {};
  return comp(
    padLast(cols, 0),
    map(
      juxt(U8, (x) => x > 31 && x < 127 ? String.fromCharCode(x) : ".")
    ),
    partition(cols, true),
    map(
      juxt(
        (x) => x.map((y) => y[0]).join(" "),
        (x) => x.map((y) => y[1]).join("")
      )
    ),
    mapIndexed((i, [h, a]) => `${U32(address + i * cols)} | ${h} | ${a}`)
  );
}
const hexDumpString = (opts, src) => [...hexDump(opts, src)].join("\n");
export {
  hexDump,
  hexDumpString
};
