import type { Transducer } from "./api.js";
/**
 * Stateful transducer. Ignores the actual input values, but
 * produces time measurements since last value processed,
 * e.g. for use in async usage contexts.
 *
 * @example
 * ```ts tangle:../export/benchmark.ts
 * import { fromInterval, trace } from "@thi.ng/rstream";
 * import { benchmark, comp, movingAverage } from "@thi.ng/transducers";
 *
 * fromInterval(16).subscribe(
 *   trace(),
 *   { xform: comp(benchmark(), movingAverage(60)) }
 * );
 * // 16.766666666666666
 * // 17.05
 * // 17.033333333333335
 * // 17.033333333333335
 * // ...
 * ```
 */
export declare function benchmark(): Transducer<any, number>;
export declare function benchmark(src: Iterable<any>): IterableIterator<number>;
//# sourceMappingURL=benchmark.d.ts.map