import { compR } from "./compr.js";
import { ensureReduced, isReduced, unreduced } from "./reduced.js";
const cat = () => (rfn) => {
  const r = rfn[2];
  return compR(rfn, (acc, x) => {
    if (x) {
      for (let y of unreduced(x) || []) {
        acc = r(acc, y);
        if (isReduced(acc)) {
          break;
        }
      }
    }
    return isReduced(x) ? ensureReduced(acc) : acc;
  });
};
export {
  cat
};
