import type { IRandom } from "@thi.ng/random";
/**
 * Returns an infinite iterator of random choices and their (optional) weights.
 * If `weights` is given, it must have at least the same size as `choices`. If
 * omitted, each choice will have same probability.
 *
 * @remarks
 * Internally uses
 * [`weightedRandom()`](https://docs.thi.ng/umbrella/random/functions/weightedRandom.html).
 *
 * @example
 * ```ts tangle:../export/choices.ts
 * import { choices, frequencies, take, transduce } from "@thi.ng/transducers";
 *
 * const res = transduce(
 *   take(1000),
 *   frequencies(),
 *   choices("abcd", [1, 0.5, 0.25, 0.125])
 * );
 *
 * console.log(res);
 * // Map(4) {
 * //   "a": 544,
 * //   "b": 263,
 * //   "c": 131,
 * //   "d": 62,
 * // }
 * ```
 *
 * @param choices -
 * @param weights -
 */
export declare const choices: <T>(choices: ArrayLike<T> & Iterable<T>, weights?: ArrayLike<number>, rnd?: IRandom) => IterableIterator<T>;
//# sourceMappingURL=choices.d.ts.map