import type { Predicate2 } from "@thi.ng/api";
import type { Transducer } from "./api.js";
/**
 * Transducer which for each input `x` (apart from the very first one) applies
 * given predicate `pred` to previous input and `x`. Only passes values
 * downstream as long as the predicate returns a falsy result. Once the result
 * is truthy, `x` is considered converged and the transformation is terminated
 * (by emitting a {@link reduced} value).
 *
 * @remarks
 * This can be used to limit processing of inputs only as long as there're
 * noticeable changes (according to the predicate) and then stop the transducer
 * pipeline once results have converged.
 *
 * See also: {@link takeWhile}
 *
 * @example
 * ```ts tangle:../export/converge.ts
 * import { converge, iterate } from "@thi.ng/transducers";
 *
 * // process as long as difference to prev value is >= 0.01
 * const res = [...converge(
 *       // predicate
 *       (a, b) => Math.abs(a - b) < 0.01,
 *       // input sequence
 *       iterate((x, i) => x + Math.pow(2, -i), 0)
 * )];
 *
 * console.log(res);
 * // [ 0, 0.5, 0.75, 0.875, 0.9375, 0.96875, 0.984375, 0.9921875 ]
 * ```
 *
 * @param pred -
 */
export declare function converge<T>(pred?: Predicate2<T>): Transducer<T, T>;
export declare function converge<T>(pred: Predicate2<T>, src: Iterable<T>): IterableIterator<T>;
//# sourceMappingURL=converge.d.ts.map