import type { Fn0 } from "@thi.ng/api";
import type { Reducer, Transducer } from "./api.js";
export type ConvolutionKernel1D = [number, number][];
export type ConvolutionKernel2D = [number, [number, number]][];
export type ConvolutionKernel3D = [number, [number, number, number]][];
export interface ConvolutionOpts<K> {
    /**
     * Current cell states
     */
    src: ArrayLike<number>;
    /**
     * Kernel weights
     */
    weights?: Iterable<number>;
    /**
     * Convolution kernel, pre-build via `buildKernel*`
     */
    kernel?: K;
    /**
     * Cell matrix width
     */
    width: number;
    /**
     * Kernel width (MUST be odd number)
     */
    kwidth?: number;
    /**
     * True, if convolution is seamless / wraps around near edges.
     * Default: true
     */
    wrap?: boolean;
    /**
     * Only used if `wrap = false`. Used as neighboring cell values when
     * processing edge cells. Default: 0
     */
    border?: number;
    /**
     * Optional custom reducer to process convoluted results. Default:
     * `add`
     */
    reduce?: Fn0<Reducer<number, number>>;
}
export interface Convolution1DOpts extends ConvolutionOpts<ConvolutionKernel1D> {
}
export interface Convolution2DOpts extends ConvolutionOpts<ConvolutionKernel2D> {
    height: number;
    kheight?: number;
}
export declare const buildKernel1d: (weights: Iterable<number>, w: number) => ConvolutionKernel1D;
export declare const buildKernel2d: (weights: Iterable<number>, w: number, h?: number) => ConvolutionKernel2D;
export declare function convolve1d(opts: Convolution1DOpts): Transducer<number, number>;
export declare function convolve1d(opts: Convolution1DOpts, indices: Iterable<number>): IterableIterator<number>;
export declare function convolve2d(opts: Convolution2DOpts): Transducer<number[], number>;
export declare function convolve2d(opts: Convolution2DOpts, indices: Iterable<number[]>): IterableIterator<number>;
//# sourceMappingURL=convolve.d.ts.map