import type { Predicate2 } from "@thi.ng/api";
import type { Transducer } from "./api.js";
/**
 * Transducer. Deduplicates **consecutive** values which are equal according to
 * given (optional) predicate (default: `===`).
 *
 * @remarks
 * See {@link distinct} to remove **any** duplicates.
 *
 * @example
 * ```ts tangle:../export/dedupe.ts
 * import { dedupe } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...dedupe([1, 1, 2, 3, 3, 3, 1])]
 * );
 * // [ 1, 2, 3, 1 ]
 * ```
 *
 * @param equiv
 */
export declare function dedupe<T>(equiv?: Predicate2<T>): Transducer<T, T>;
export declare function dedupe<T>(src: Iterable<T>): IterableIterator<T>;
export declare function dedupe<T>(equiv: Predicate2<T>, src: Iterable<T>): IterableIterator<T>;
//# sourceMappingURL=dedupe.d.ts.map