/**
 * Returns the concatentation of `x` with itself. If input is an iterable, it
 * MUST be finite!
 *
 * @remarks
 * Also see the {@link concat}, {@link duplicate}, {@link repeat} and
 * {@link repeatedly} for achieving a different kinds of value duplication.
 *
 * @example
 * ```ts tangle:../export/dup.ts
 * import { dup, range } from "@thi.ng/transducers";
 *
 * console.log(dup("hello"));
 * // "hellohello"
 *
 * console.log(dup([1, 2, 3]));
 * // [ 1, 2, 3, 1, 2, 3 ]
 *
 * console.log([...dup(range(3))]);
 * // [ 0, 1, 2, 0, 1, 2 ]
 * ```
 *
 * @param x -
 */
export declare function dup(x: string): string;
export declare function dup<T>(x: T[]): T[];
export declare function dup<T>(x: Iterable<T>): Iterable<T>;
//# sourceMappingURL=dup.d.ts.map