import type { Predicate } from "@thi.ng/api";
import type { Reducer } from "./api.js";
/**
 * Reducer which applies optional `pred` function to each value and
 * terminates early if the predicate returned a falsy result. If no
 * predicate is given the values are checked via JS native truthiness
 * rules (i.e. 0, "", false, null, undefined are all falsy).
 *
 * Returns true if *all* values passed test.
 *
 * @example
 * ```ts tangle:../export/every.ts
 * import { every } from "@thi.ng/transducers";
 *
 * console.log(
 *   every((x)=> x > 0, [1,2,-1,3])
 * );
 * // false
 * ```
 *
 * @param pred -
 */
export declare function every<T>(pred?: Predicate<T>): Reducer<boolean, T>;
export declare function every<T>(src: Iterable<T>): boolean;
export declare function every<T>(pred: Predicate<T>, src: Iterable<T>): boolean;
//# sourceMappingURL=every.d.ts.map