/**
 * Yields iterator of given iterable which repeats the first and/or last
 * value(s) `numLeft`/`numRight` times (default: 1).
 *
 * @remarks
 * By default both sides are repeated, but can be adjusted by setting
 * either of them to zero. `numRight` defaults to same value as
 * `numLeft`.
 *
 * Also see {@link padSides}, {@link wrapSides}.
 *
 * @example
 * ```ts tangle:../export/extend-sides.ts
 * import { extendSides } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...extendSides([1, 2, 3])]
 * );
 * // [ 1,  1, 2, 3,  3]
 *
 * console.log(
 *   [...extendSides([1, 2, 3], 3)]
 * );
 * // [ 1, 1, 1,  1, 2, 3,  3, 3, 3 ]
 *
 * console.log(
 *   [...extendSides([1, 2, 3], 0, 3)]
 * );
 * // [ 1, 2, 3,  3, 3, 3 ]
 * ```
 *
 * - {@link padSides}
 * - {@link wrapSides}
 *
 * @param src -
 * @param numLeft -
 * @param numRight -
 */
export declare function extendSides<T>(src: Iterable<T>, numLeft?: number, numRight?: number): IterableIterator<T>;
//# sourceMappingURL=extend-sides.d.ts.map