import { fuzzyMatch } from "@thi.ng/arrays/fuzzy-match";
import { __iter } from "./iterator.js";
import { filter } from "./filter.js";
function filterFuzzy(...args) {
  const iter = args.length > 1 && __iter(filterFuzzy, args);
  if (iter) {
    return iter;
  }
  const query = args[0];
  const { key, equiv } = args[1] || {};
  return filter(
    (x) => fuzzyMatch(key != null ? key(x) : x, query, equiv)
  );
}
export {
  filterFuzzy
};
