import { __groupByOpts } from "./internal/group-opts.js";
import { $$reduce } from "./reduce.js";
function groupByMap(...args) {
  const res = $$reduce(groupByMap, args);
  if (res !== void 0) return res;
  const opts = __groupByOpts(args[0]);
  const [init, complete, reduce] = opts.group;
  return [
    () => /* @__PURE__ */ new Map(),
    (acc) => {
      for (let k of acc.keys()) {
        acc.set(k, complete(acc.get(k)));
      }
      return acc;
    },
    (acc, x) => {
      const k = opts.key(x);
      return acc.set(
        k,
        acc.has(k) ? reduce(acc.get(k), x) : reduce(init(), x)
      );
    }
  ];
}
export {
  groupByMap
};
