import type { Transducer } from "./api.js";
/**
 * Pre-configured version of {@link interpolate} for numeric values and using
 * pairwise linear interpolation.
 *
 * @remarks
 * The number of samples per interval is configurable. No values will be
 * produced if there're less than 2 inputs.
 *
 * See also:
 * - {@link interpolate}
 * - {@link interpolateHermite}
 *
 * @param n -
 */
export declare function interpolateLinear(n: number): Transducer<number, number>;
export declare function interpolateLinear(n: number, src: Iterable<number>): IterableIterator<number>;
//# sourceMappingURL=interpolate-linear.d.ts.map