import type { FnAny } from "@thi.ng/api";
import type { Transducer, TxLike } from "./api.js";
/**
 * Takes a transducer and input iterable. Returns iterator of
 * transformed results.
 *
 * @param xform -
 * @param src -
 */
export declare function iterator<A, B>(xform: TxLike<A, B>, src: Iterable<A>): IterableIterator<B>;
/**
 * Optimized version of {@link iterator} for transducers which are
 * guaranteed to:
 *
 * 1) Only produce none or a single result per input
 * 2) Do not require a `completion` reduction step
 *
 * @param xform -
 * @param src -
 */
export declare function iterator1<A, B>(xform: TxLike<A, B>, src: Iterable<A>): IterableIterator<B>;
/**
 * Helper function used by various transducers to wrap themselves as
 * transforming iterators. Delegates to {@link iterator1} by default.
 *
 * @param xform -
 * @param args -
 * @param impl -
 *
 * @internal
 */
export declare const __iter: (xform: FnAny<Transducer<any, any>>, args: any[], impl?: typeof iterator1) => IterableIterator<any> | undefined;
//# sourceMappingURL=iterator.d.ts.map