import type { Transducer } from "./api.js";
import type { ILength } from "@thi.ng/api";
/**
 * Similar to `map((x) => x.length)`. A transducer which returns the `.length`
 * of each input (optionally with offset `n` added, default: 0) and yields
 * sequence of these values.
 *
 * @example
 * ```ts tangle:../export/length.ts
 * import { length } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...length(0, ["a", "bc", "def"])]
 * );
 * // [1, 2, 3]
 * ```
 *
 * @param n - optional offset
 */
export declare function length(n?: number): Transducer<ILength, number>;
export declare function length(n: number, src: Iterable<ILength>): IterableIterator<number>;
//# sourceMappingURL=length.d.ts.map