/**
 * Iterator yielding `steps` + 1 interpolated values on a line in the closed
 * `[start .. end]` interval.
 *
 * @remarks
 * This is similar to {@link range}, but potentially provides more precise
 * values (by avoiding the accumulation of floating point errors during
 * iteration).
 *
 * Similar functionality (w/ more options) is availble here:
 * [`line()`](https://docs.thi.ng/umbrella/dsp/functions/line.html).
 *
 * @example
 * ```ts tangle:../export/line.ts
 * import { line } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...line(50, 100, 10)]
 * );
 * // [
 * //    50, 55, 60, 65, 70,
 * //    75, 80, 85, 90, 95,
 * //   100
 * // ]
 * ```
 *
 * @param start -
 * @param end -
 * @param steps -
 */
export declare const line: (start: number, end: number, steps?: number) => IterableIterator<number>;
//# sourceMappingURL=line.d.ts.map