import type { Fn2 } from "@thi.ng/api";
import type { Transducer } from "./api.js";
/**
 * Transducer. Similar to {@link map}, but given `fn` takes two arguments:
 * `index` and `value` to transform.
 *
 * @remarks
 * An optional start index `offset` can be provided (default 0).
 *
 * @example
 * ```ts tangle:../export/map-indexed.ts
 * import { mapIndexed } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...mapIndexed((i, x) => ["id" + i, x * 10], 42, [1, 2, 3])]
 * );
 * // [ [ "id42", 10 ], [ "id43", 20 ], [ "id44", 30 ] ]
 * ```
 *
 * @param fn - transformation function
 * @param offset - initial index
 */
export declare function mapIndexed<A, B>(fn: Fn2<number, A, B>, offset?: number): Transducer<A, B>;
export declare function mapIndexed<A, B>(fn: Fn2<number, A, B>, src: Iterable<A>): IterableIterator<B>;
export declare function mapIndexed<A, B>(fn: Fn2<number, A, B>, offset: number, src: Iterable<A>): IterableIterator<B>;
//# sourceMappingURL=map-indexed.d.ts.map