import { __iter } from "./iterator.js";
import { map } from "./map.js";
function mapKeys(...args) {
  const iter = __iter(mapKeys, args);
  if (iter) {
    return iter;
  }
  const keys = args[0];
  const copy = args[1] !== false;
  return map((x) => {
    const res = copy ? Object.assign({}, x) : x;
    for (let k in keys) {
      res[k] = keys[k](x[k], x);
    }
    return res;
  });
}
export {
  mapKeys
};
