import { compR } from "./compr.js";
import { __iter } from "./iterator.js";
function mapNth(...args) {
  const iter = __iter(mapNth, args);
  if (iter) {
    return iter;
  }
  let n = args[0] - 1;
  let offset;
  let fn;
  if (typeof args[1] === "number") {
    offset = args[1];
    fn = args[2];
  } else {
    fn = args[1];
    offset = 0;
  }
  return (rfn) => {
    const r = rfn[2];
    let skip = 0, off = offset;
    return compR(rfn, (acc, x) => {
      if (off === 0) {
        if (skip === 0) {
          skip = n;
          return r(acc, fn(x));
        }
        skip--;
      } else {
        off--;
      }
      return r(acc, x);
    });
  };
}
export {
  mapNth
};
