import type { Maybe, Predicate } from "@thi.ng/api";
import type { Transducer } from "./api.js";
/**
 * Similar to {@link matchFirst}, but matches only the **last** value which
 * passed the predicate check. If `src` input is given, returns last match found
 * (or `undefined`).
 *
 * @example
 * ```ts tangle:../export/match-last.ts
 * import { comp, map, matchLast, push, transduce } from "@thi.ng/transducers";
 *
 * console.log(
 *   matchLast((x) => x >= 5, [3, 1, 6, 5, 4, 2])
 * );
 * // 5
 *
 * const res = transduce(
 *   comp(
 *     matchLast((x) => x >= 5),
 *     map((x) => x * 10)
 *   ),
 *   push(),
 *   [3, 1, 6, 5, 4, 2]
 * );
 *
 * console.log(res);
 * // [ 50 ]
 * ```
 *
 * @param pred - predicate function
 */
export declare function matchLast<T>(pred: Predicate<T>): Transducer<T, T>;
export declare function matchLast<T>(pred: Predicate<T>, src: Iterable<T>): Maybe<T>;
//# sourceMappingURL=match-last.d.ts.map