import type { Transducer } from "./api.js";
/**
 * Computes the [Simple Moving
 * Average](https://en.wikipedia.org/wiki/Moving_average#Simple_moving_average)
 * of given period.
 *
 * @remarks
 * The number of results will be `period-1` less than the number of processed
 * inputs and no outputs will be produced if there were less than `period` input
 * values.
 *
 * Also see the [thi.ng/transducers-stats](https://thi.ng/transducers-stats)
 * package for more optimized and alternative MA strategies.
 *
 * @param period -
 */
export declare function movingAverage(period: number): Transducer<number, number>;
export declare function movingAverage(period: number, src: Iterable<number>): IterableIterator<number>;
//# sourceMappingURL=moving-average.d.ts.map