import type { SortOpts, Transducer } from "./api.js";
/**
 * Transducer. Similar to {@link movingAverage}, but yields median of sliding
 * window and supports non-numeric inputs.
 *
 * @remarks
 * The optional `key` and `cmp` function options can be used to select / compute
 * a sortable value and change sorting behavior.
 *
 * @param n - window size
 * @param opts -
 */
export declare function movingMedian<A, B>(n: number, opts?: Partial<SortOpts<A, B>>): Transducer<A, A>;
export declare function movingMedian<A, B>(n: number, src: Iterable<A>): IterableIterator<A>;
export declare function movingMedian<A, B>(n: number, opts: Partial<SortOpts<A, B>>, src: Iterable<A>): IterableIterator<A>;
//# sourceMappingURL=moving-median.d.ts.map