import { comp } from "./comp.js";
import { __sortOpts } from "./internal/sort-opts.js";
import { __iter } from "./iterator.js";
import { map } from "./map.js";
import { partition } from "./partition.js";
function movingMedian(...args) {
  const iter = __iter(movingMedian, args);
  if (iter) return iter;
  const { key, compare } = __sortOpts(args[1]);
  const n = args[0];
  const m = n >> 1;
  return comp(
    partition(n, 1, true),
    map(
      (window) => window.slice().sort((a, b) => compare(key(a), key(b)))[m]
    )
  );
}
export {
  movingMedian
};
