import { frequencies } from "./frequencies.js";
import { $$reduce } from "./reduce.js";
function normFrequenciesAuto(...args) {
  const res = $$reduce(normFrequenciesAuto, args);
  if (res !== void 0) return res;
  const [init, complete, reduce] = frequencies(...args);
  let norm = 0;
  return [
    init,
    (acc) => {
      acc = complete(acc);
      for (let p of acc) {
        acc.set(p[0], p[1] / norm);
      }
      return acc;
    },
    (acc, x) => (norm++, reduce(acc, x))
  ];
}
export {
  normFrequenciesAuto
};
