import type { Fn } from "@thi.ng/api";
import type { Reducer } from "./api.js";
/**
 * Similar to {@link frequencies}, but with each bin value normalized to given
 * `norm`.
 *
 * @remarks
 * Also see {@link normFrequenciesAuto}.
 *
 * @example
 * ```ts tangle:../export/norm-frequencies.ts
 * import { normFrequencies } from "@thi.ng/transducers";
 *
 * const items = [1, 2, 3, 1, 1, 4, 2, 5, 1, 2];
 *
 * console.log(
 *   normFrequencies(10, items)
 * );
 * // Map(5) {
 * //   1 => 0.4,
 * //   2 => 0.3,
 * //   3 => 0.1,
 * //   4 => 0.1,
 * //   5 => 0.1,
 * // }
 * ```
 *
 * @param norm -
 */
export declare function normFrequencies<A>(norm: number): Reducer<A, Map<A, number>>;
export declare function normFrequencies<A>(norm: number, src: Iterable<A>): Map<A, number>;
export declare function normFrequencies<A, B>(norm: number, key: Fn<A, B>): Reducer<A, Map<B, number>>;
export declare function normFrequencies<A, B>(norm: number, key: Fn<A, B>, src: Iterable<A>): Map<B, number>;
//# sourceMappingURL=norm-frequencies.d.ts.map