import { map } from "./map.js";
function* normRange(n, includeLast = true, reverse = false) {
  if (n > 0) {
    for (let i = 0, m = includeLast ? n + 1 : n; i < m; i++) {
      yield reverse ? 1 - i / n : i / n;
    }
  }
}
function* normRange2d(nx, ny, includeLastX = true, includeLastY = true) {
  const rx = [...normRange(nx, includeLastX)];
  for (let y of normRange(ny, includeLastY)) {
    yield* map((x) => [x, y], rx);
  }
}
function* normRange3d(nx, ny, nz, includeLastX = true, includeLastY = true, includeLastZ = true) {
  const sliceXY = [...normRange2d(nx, ny, includeLastX, includeLastY)];
  for (let z of normRange(nz, includeLastZ)) {
    yield* map((xy) => [...xy, z], sliceXY);
  }
}
export {
  normRange,
  normRange2d,
  normRange3d
};
