import type { Transducer } from "./api.js";
/**
 * Ensures the total number of transformed values will be multiples of `n`.
 *
 * @remarks
 * Only makes sense for finite streams / reductions. Does nothing if the to be
 * transformed data source has exactly multiple of `n` values, but if not pads /
 * supplies additional `fill` values at the end until the next multiple is
 * reached. No padding takes place if input is empty, since length 0 is always a
 * multiple.
 *
 * @example
 * ```ts tangle:../export/pad-last.ts
 * import { padLast } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...padLast(8, 0, [1, 2, 3, 4, 5])]
 * );
 * // [ 1, 2, 3, 4, 5, 0, 0, 0 ]
 *
 * console.log(
 *   [...padLast(8, 0, [1])]
 * );
 * // [ 1, 0, 0, 0, 0, 0, 0, 0 ]
 *
 * console.log(
 *   [...padLast(8, 0, [])]
 * );
 * // []
 *
 * console.log(
 *   [...padLast(4, 0, [1, 2])]
 * );
 * // [ 1, 2, 0, 0 ]
 *
 * console.log(
 *   [...padLast(4, 0, [1, 2, 3, 4, 5])]
 * );
 * // [ 1, 2, 3, 4, 5, 0, 0, 0 ]
 * ```
 *
 * @param n -
 * @param fill -
 */
export declare function padLast<T>(n: number, fill: T): Transducer<T, T>;
export declare function padLast<T>(n: number, fill: T, src: Iterable<T>): IterableIterator<T>;
//# sourceMappingURL=pad-last.d.ts.map