import { isIterable } from "@thi.ng/checks/is-iterable";
import { iterator } from "./iterator.js";
import { isReduced } from "./reduced.js";
function padLast(n, fill, src) {
  return isIterable(src) ? iterator(padLast(n, fill), src) : ([init, complete, reduce]) => {
    let m = 0;
    return [
      init,
      (acc) => {
        let rem = m % n;
        if (rem > 0) {
          while (++rem <= n && !isReduced(acc)) {
            acc = reduce(acc, fill);
          }
        }
        return complete(acc);
      },
      (acc, x) => (m++, reduce(acc, x))
    ];
  };
}
export {
  padLast
};
