import type { Fn } from "@thi.ng/api";
import type { Transducer } from "./api.js";
/**
 * Transducer. Applies given `fn` to each incoming value and collects
 * values until the return value of the `fn` has changed. Once this
 * happens yields chunk of buffered values.
 *
 * @example
 * ```ts tangle:../export/partition-by.ts
 * import { partitionBy } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...partitionBy((x) => x & 1, [1, 2, 4, 6, 3, 5, 8, 4])]
 * );
 * // [ [ 1 ], [ 2, 4, 6 ], [ 3, 5 ], [ 8, 4 ] ]
 * ```
 *
 * @param fn -
 * @param stateful -
 */
export declare function partitionBy<T>(fn: Fn<T, any> | (() => Fn<T, any>), stateful?: boolean): Transducer<T, T[]>;
export declare function partitionBy<T>(fn: Fn<T, any> | (() => Fn<T, any>), src: Iterable<T>): IterableIterator<T[]>;
export declare function partitionBy<T>(fn: Fn<T, any> | (() => Fn<T, any>), stateful: boolean, src: Iterable<T>): IterableIterator<T[]>;
//# sourceMappingURL=partition-by.d.ts.map