import type { Transducer } from "./api.js";
/**
 * Transducer. Yields cyclic sequence of user defined variable sized
 * chunks. The last partition emitted is allowed to be incomplete.
 *
 * @example
 * ```ts tangle:../export/partition-of.ts
 * import { partitionOf, range } from "@thi.ng/transducers";
 *
 * console.log(
 *   [...partitionOf([3, 2, 4], range(20))]
 * );
 * // [ [ 0, 1, 2 ],
 * //   [ 3, 4 ],
 * //   [ 5, 6, 7, 8 ],
 * //   [ 9, 10, 11 ],
 * //   [ 12, 13 ],
 * //   [ 14, 15, 16, 17 ],
 * //   [ 18, 19 ] ]
 * ```
 *
 * @param sizes -
 */
export declare function partitionOf<T>(sizes: number[]): Transducer<T, T[]>;
export declare function partitionOf<T>(sizes: number[], src: Iterable<T>): IterableIterator<T[]>;
//# sourceMappingURL=partition-of.d.ts.map