import { isIterable } from "@thi.ng/checks/is-iterable";
import { iterator } from "./iterator.js";
import { partitionBy } from "./partition-by.js";
function partitionOf(sizes, src) {
  return isIterable(src) ? iterator(partitionOf(sizes), src) : partitionBy(() => {
    let i = 0, j = 0;
    return () => {
      if (i++ === sizes[j]) {
        i = 1;
        j = (j + 1) % sizes.length;
      }
      return j;
    };
  }, true);
}
export {
  partitionOf
};
