import { comp } from "./comp.js";
import { __sortOpts } from "./internal/sort-opts.js";
import { __iter, iterator } from "./iterator.js";
import { mapcat } from "./mapcat.js";
import { partition } from "./partition.js";
function partitionSort(...args) {
  const iter = __iter(partitionSort, args, iterator);
  if (iter) {
    return iter;
  }
  const { key, compare } = __sortOpts(args[1]);
  return comp(
    partition(args[0], true),
    mapcat(
      (window) => window.slice().sort((a, b) => compare(key(a), key(b)))
    )
  );
}
export {
  partitionSort
};
