import { __iter, iterator } from "./iterator.js";
function partition(...args) {
  const iter = __iter(partition, args, iterator);
  if (iter) {
    return iter;
  }
  let size = args[0], all, step;
  if (typeof args[1] == "number") {
    step = args[1];
    all = args[2];
  } else {
    step = size;
    all = args[1];
  }
  return ([init, complete, reduce]) => {
    let buf = [];
    let skip = 0;
    return [
      init,
      (acc) => {
        if (all && buf.length > 0) {
          acc = reduce(acc, buf);
          buf = [];
        }
        return complete(acc);
      },
      (acc, x) => {
        if (skip <= 0) {
          if (buf.length < size) {
            buf.push(x);
          }
          if (buf.length === size) {
            acc = reduce(acc, buf);
            buf = step < size ? buf.slice(step) : [];
            skip = step - size;
          }
        } else {
          skip--;
        }
        return acc;
      }
    ];
  };
}
export {
  partition
};
