import { isReduced, Reduced } from "./reduced.js";
function range(from, to, step) {
  return new Range(from, to, step);
}
class Range {
  from;
  to;
  step;
  constructor(from, to, step) {
    if (from === void 0) {
      from = 0;
      to = Infinity;
    } else if (to === void 0) {
      to = from;
      from = 0;
    }
    step = step === void 0 ? from < to ? 1 : -1 : step;
    this.from = from;
    this.to = to;
    this.step = step;
  }
  *[Symbol.iterator]() {
    let { from, to, step } = this;
    if (step > 0) {
      while (from < to) {
        yield from;
        from += step;
      }
    } else if (step < 0) {
      while (from > to) {
        yield from;
        from += step;
      }
    }
  }
  $reduce(rfn, acc) {
    const step = this.step;
    if (step > 0) {
      for (let i = this.from, n = this.to; i < n && !isReduced(acc); i += step) {
        acc = rfn(acc, i);
      }
    } else {
      for (let i = this.from, n = this.to; i > n && !isReduced(acc); i += step) {
        acc = rfn(acc, i);
      }
    }
    return acc;
  }
}
export {
  Range,
  range
};
