import type { Fn0, FnAny } from "@thi.ng/api";
import type { IReducible, Reducer, ReductionFn } from "./api.js";
export declare function reduce<A, B>(rfn: Reducer<A, B>, src: Iterable<A>): B;
export declare function reduce<A, B>(rfn: Reducer<A, B>, acc: B, src: Iterable<A>): B;
export declare function reduce<A, B>(rfn: Reducer<A, B>, src: IReducible<A, B>): B;
export declare function reduce<A, B>(rfn: Reducer<A, B>, acc: A, src: IReducible<A, B>): B;
export declare function reduceRight<A, B>(rfn: Reducer<A, B>, src: ArrayLike<A>): B;
export declare function reduceRight<A, B>(rfn: Reducer<A, B>, acc: B, src: ArrayLike<A>): B;
/**
 * Convenience helper for building a full {@link Reducer} using the identity
 * function (i.e. `(x) => x`) as completion step (true for 90% of all
 * bundled transducers).
 *
 * @param init - init step of reducer
 * @param rfn - reduction step of reducer
 */
export declare const reducer: <A, B>(init: Fn0<B>, rfn: ReductionFn<A, B>) => Reducer<A, B>;
export declare const $$reduce: (rfn: FnAny<Reducer<any, any>>, args: any[]) => any;
//# sourceMappingURL=reduce.d.ts.map