import type { IObjectOf } from "@thi.ng/api";
import type { Reducer, Transducer } from "./api.js";
/**
 * Transducer. Takes an object of key mappings and returns function applying
 * these mapping/renames.
 *
 * @remarks
 * Keys in `kmap` are the new/renamed keys, their values the original names. For
 * keys which simply should be kept, but not renamed, set their value to `true`.
 *
 * @param kmap
 * @param rfn
 */
export declare function rename<A, B>(kmap: IObjectOf<PropertyKey | boolean> | Array<PropertyKey>, rfn?: Reducer<[PropertyKey, any], B>): Transducer<A[], B>;
export declare function rename<A, B>(kmap: IObjectOf<PropertyKey | boolean> | Array<PropertyKey>, rfn: Reducer<[PropertyKey, any], B>, src: Iterable<A[]>): IterableIterator<B>;
//# sourceMappingURL=rename.d.ts.map