import type { IRandom } from "@thi.ng/random";
import type { Transducer } from "./api.js";
/**
 * Transducer which only yields values with given `prob` probability
 * (0.0 .. 1.0 range). Supports custom PRNGs via
 * [`IRandom`](https://docs.thi.ng/umbrella/random/interfaces/IRandom.html) interface.
 *
 * @example
 * ```ts tangle:../export/sample.ts
 * import { range, sample } from "@thi.ng/transducers";
 *
 * // 10% probability
 * console.log(
 *   [...sample(0.1, range(100))]
 * );
 * // [ 3, 24, 25, 36, 43, 49, 59, 64, 82, 86, 89 ]
 * ```
 *
 * @param prob -
 */
export declare function sample<T>(prob: number): Transducer<T, T>;
export declare function sample<T>(prob: number, rnd: IRandom): Transducer<T, T>;
export declare function sample<T>(prob: number, src: Iterable<T>): IterableIterator<T>;
export declare function sample<T>(prob: number, rnd: IRandom, src: Iterable<T>): IterableIterator<T>;
//# sourceMappingURL=sample.d.ts.map